/*******************************************************}
{                                                       }
{               Borland DB Web                          }
{           Data aware Web controls                     }
{ Copyright (c) 2003, 2004 Borland Software Corporation }
{                                                       }
{*******************************************************/

using System;
using System.Data;
using System.IO;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Collections;
using System.Collections.Specialized;
using System.ComponentModel;
using System.ComponentModel.Design;
using System.ComponentModel.Design.Serialization;
using System.Drawing;
using System.Drawing.Design;
using System.Text;


#region DBWebLookControls

namespace Borland.Data.Web
{
   #region DBWebListBox

	/// <summary>
	/// Data aware ListBox control for use with DBWebDataSource
	/// </summary>

	[Designer("Borland.Data.Web.DBWebControlDesigner"),
   ToolboxBitmap(typeof(Borland.Data.Web.DBWebListBox),
   "Borland.Data.Web.DBWebListBox.bmp"),
	ToolboxData("<{0}:DBWebListBox runat=server></{0}:DBWebListBox>")]
   public class DBWebListBox : ListBox, IDBWebLookupColumnLink, IPostBackDataHandler
   {
      private DBWebLookupColumnLink FColumnLink;
		private IDBWebLookupColumnLink IColumnLink;
		public DBWebListBox() : base()
      {
			FColumnLink = new DBWebLookupColumnLink(this);
         IColumnLink = (FColumnLink as IDBWebLookupColumnLink);
      }

		protected override void OnInit(EventArgs e)
		{
			base.OnInit(e);
			if( Page != null )
				Page.RegisterRequiresPostBack(this);
      }

		#region IPostBackDataHandler
      // RaisePostDataChangedEvent is called prior to DataBind()
      // DataSet and related properties are NOT available here
      // Child controls are not available
		bool IPostBackDataHandler.LoadPostData(string postDataKey,
			NameValueCollection postCollection)
      {
         if( this.Visible )
	      	FColumnLink.LoadPostData(postDataKey, postCollection);
         return false;
      }

	   void IPostBackDataHandler.RaisePostDataChangedEvent()
   	{
		}
		#endregion

		#region IDBWebDataLink
		string IDBWebDataLink.TableName
		{
			get
			{
				return IColumnLink.TableName;
			}
			set
			{
				IColumnLink.TableName = value;
			}
		}
      IDBDataSource IDBWebDataLink.DBDataSource
      {
      	get
         {
         	return (IColumnLink as IDBWebDataLink).DBDataSource;
         }
         set
         {
         	IColumnLink.DBDataSource = value;
         }
      }
		#endregion
		#region IDBWebColumnLink
      string IDBWebColumnLink.ColumnName
      {
      	get
         {
         	return IColumnLink.ColumnName;
         }
         set
         {
         	IColumnLink.ColumnName = value;
         }
      }
		#endregion
		#region IDBWebLookupColumnLink
      string IDBWebLookupColumnLink.DataTextField
      {
      	get
         {
         	return IColumnLink.DataTextField;
         }
         set
         {
         	IColumnLink.DataTextField = value;
         }
      }
      string IDBWebLookupColumnLink.DataValueField
      {
      	get
         {
         	return IColumnLink.DataValueField;
         }
         set
         {
         	IColumnLink.DataValueField = value;
         }
      }
      string IDBWebLookupColumnLink.LookupTableName
      {
      	get
         {
         	return IColumnLink.LookupTableName;
         }
         set
         {
         	IColumnLink.LookupTableName = value;
         }
      }
		#endregion

		#region DBWebLookupColumnLink
      [Editor(typeof(Borland.Data.Web.TableNamePropEditor), typeof(UITypeEditor)),
		LocalizableCategoryAttribute(DBTypes.sDBWebControl),
		DefaultValue(null)]
	  [LocalizableDescriptionAttribute("TableName")]
      public string TableName
      {
      	get
         {
	      	return IColumnLink.TableName;
         }
      	set
         {
	      	IColumnLink.TableName = value;
         }
      }
		[LocalizableCategoryAttribute(DBTypes.sDBWebControl),
		DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden),
		DefaultValue(null)]
	  [LocalizableDescriptionAttribute("DataSource")]
      public IDBDataSource DBDataSource
      {
      	get
         {
         	return IColumnLink.DBDataSource;
         }
         set
         {
         	IColumnLink.DBDataSource = value;
         }
      }

      [Editor(typeof(Borland.Data.Web.ColumnNamePropEditor), typeof(UITypeEditor)),
		LocalizableCategoryAttribute(DBTypes.sDBWebControl),
		DefaultValue(null)]
	  [LocalizableDescriptionAttribute("ColumnName")]
      public string ColumnName
      {
      	get
         {
         	return IColumnLink.ColumnName;
         }
         set
         {
         	IColumnLink.ColumnName = value;
         }
      }
      [Editor(typeof(Borland.Data.Web.TableNamePropEditor), typeof(UITypeEditor)),
		LocalizableCategoryAttribute(DBTypes.sDBWebControl),
		DefaultValue(null)]
	  [LocalizableDescriptionAttribute("LookupTableName")]
      public string LookupTableName
      {
      	get
         {
         	return IColumnLink.LookupTableName;
         }
         set
         {
         	IColumnLink.LookupTableName = value;
         }
      }
      [Editor(typeof(Borland.Data.Web.LookupColumnNamePropEditor), typeof(UITypeEditor)),
		LocalizableCategoryAttribute(DBTypes.sDBWebControl),
      DefaultValue(null)]
	  [LocalizableDescriptionAttribute("DataTextField")]
      public override string DataTextField
      {
      	get
         {
         	return IColumnLink.DataTextField;
         }
         set
         {
         	base.DataTextField = value;
         	IColumnLink.DataTextField = value;
         }
      }
      [Editor(typeof(Borland.Data.Web.LookupColumnNamePropEditor), typeof(UITypeEditor)),
		LocalizableCategoryAttribute(DBTypes.sDBWebControl),
	  DefaultValue(null)]
	  [LocalizableDescriptionAttribute("DataValueField")]
      public override string DataValueField
      {
      	get
         {
         	return IColumnLink.DataValueField;
         }
         set
         {
         	base.DataValueField = value;
         	IColumnLink.DataValueField = value;
         }
      }
		#endregion


		protected override void OnPreRender(EventArgs args)
		{
			base.OnPreRender(args);
			string s = Page.Request.QueryString[DBWebConst.sBorlandImageID];
			if( s != null )
				return;
			DataBind();
			if( TableName != LookupTableName )
				Page.RegisterHiddenField(DBWebDataSource.IdentPrefix + this.ID, IColumnLink.TableName + DBWebConst.Splitter + IColumnLink.ColumnName);
		}

		protected override void Render(HtmlTextWriter output)
		{
			bool error = ClassUtils.OutputErrors(Page, output, IColumnLink);
			if( !error || (IColumnLink.DBDataSource as DBWebDataSource).ErrorOption != ErrorHtmlOption.logOnErrorPage )
         	base.Render(output);
         else  // if going to a separate error hmtl page, output "OK" button.
         {
         	ClassUtils.OutputOKButton(output);
            Page.Response.End();
         }
		}

		public override void DataBind()
      {
      	try
         {
				base.DataSource = null;
				base.DataBind();
				base.Items.Clear();
				if( FColumnLink.IsDataBound )
				{
	            string CurrentValue = ClassUtils.BindLookupControl(Page, FColumnLink, this);
      	   	base.DataBind();
					if( CurrentValue == null )
					{
						this.Items.Insert(0, "");
						this.SelectedIndex = 0;
					}
	            else
   	       		this.SelectedIndex = ClassUtils.CurrentLookupIndex(this, CurrentValue);
            }
         }
         catch(Exception ex)
         {
         	if( !ClassUtils.IsDesignTime(Page) )
            {
	            Page.Response.Write(ClassUtils.GetInternalError(Page, IColumnLink, ex, this.ID));
            }
            else
            	throw new Exception(ex.Message);
         }
      }
   }
   #endregion

   #region DBWebRadioButtonList
	/// <summary>
	/// Data aware RadioButtonList control for use with DBWebDataSource
	/// </summary>
	[Designer("Borland.Data.Web.DBWebControlDesigner"),
   ToolboxBitmap(typeof(Borland.Data.Web.DBWebRadioButtonList),
   "Borland.Data.Web.DBWebRadioButtonList.bmp"),
	ToolboxData("<{0}:DBWebRadioButtonList runat=server></{0}:DBWebRadioButtonList>")]
	public class DBWebRadioButtonList : RadioButtonList, IDBWebLookupColumnLink, IPostBackDataHandler
	{
		private DBWebLookupColumnLink FColumnLink;
		private IDBWebLookupColumnLink IColumnLink;
		private RadioButtonList FRadioButtonList;
		DataTable dt;

   	public DBWebRadioButtonList() : base()
      {
         FRadioButtonList = new RadioButtonList();
         dt = new DataTable();
//         string defaultColumnName = "ColumnName1";
         string defaultColumnName = BdwResources.GetString("defaultColumnName1");
         dt.Columns.Add(defaultColumnName, Type.GetType("System.String"));
         for( int i = 0; i < 3; i++ )
         {
	         DataRow dr = dt.NewRow();
   	      dt.Rows.Add(dr);
      	   dt.Rows[i][0] = "value " + Convert.ToString(i + 1);
         }
         FRadioButtonList.DataSource = dt;
         FRadioButtonList.DataTextField = defaultColumnName;
         FRadioButtonList.DataValueField = defaultColumnName;
         FColumnLink = new DBWebLookupColumnLink(this);
         IColumnLink = (FColumnLink as IDBWebLookupColumnLink);
      }

		protected override void OnInit(EventArgs e)
		{
			base.OnInit(e);
			if( Page != null )
				Page.RegisterRequiresPostBack(this);
      }

      #region IPostBackDataHandler
      // RaisePostDataChangedEvent is called prior to DataBind()
      // DataSet and related properties are NOT available here
      // Child controls are not available
		bool IPostBackDataHandler.LoadPostData(string postDataKey,
			NameValueCollection postCollection)
      {
         if( this.Visible )
	      	FColumnLink.LoadPostData(postDataKey, postCollection);
         return false;
      }

	   void IPostBackDataHandler.RaisePostDataChangedEvent()
   	{
	   }
      #endregion

      #region IDBWebDataLink
      string IDBWebDataLink.TableName
      {
      	get
         {
         	return IColumnLink.TableName;
         }
         set
         {
         	IColumnLink.TableName = value;
         }
      }
      IDBDataSource IDBWebDataLink.DBDataSource
      {
      	get
         {
         	return (IColumnLink as IDBWebDataLink).DBDataSource;
         }
         set
         {
         	IColumnLink.DBDataSource = value;
         }
      }
      #endregion
      #region IDBWebColumnLink
      string IDBWebColumnLink.ColumnName
      {
      	get
         {
         	return IColumnLink.ColumnName;
         }
         set
         {
         	IColumnLink.ColumnName = value;
         }
      }
      #endregion
      #region IDBWebLookupColumnLink
      string IDBWebLookupColumnLink.DataTextField
      {
      	get
         {
         	return IColumnLink.DataTextField;
         }
         set
         {
         	IColumnLink.DataTextField = value;
         }
      }
      string IDBWebLookupColumnLink.LookupTableName
      {
      	get
         {
         	return IColumnLink.LookupTableName;
         }
         set
         {
         	IColumnLink.LookupTableName = value;
         }
      }
      string IDBWebLookupColumnLink.DataValueField
      {
      	get
         {
         	return IColumnLink.DataValueField;
         }
         set
         {
         	IColumnLink.DataValueField = value;
         }
      }
      #endregion

      #region DBWebLookupColumnLink
      [Editor(typeof(Borland.Data.Web.TableNamePropEditor), typeof(UITypeEditor)),
		LocalizableCategoryAttribute(DBTypes.sDBWebControl),
		DefaultValue(null)]
	  [LocalizableDescriptionAttribute("TableName")]
      public string TableName
      {
      	get
         {
	      	return IColumnLink.TableName;
         }
      	set
         {
	      	IColumnLink.TableName = value;
         }
      }
		[LocalizableCategoryAttribute(DBTypes.sDBWebControl),
		DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden),
		DefaultValue(null)]
	  [LocalizableDescriptionAttribute("DataSource")]
      public IDBDataSource DBDataSource
      {
      	get
         {
         	return IColumnLink.DBDataSource;
         }
         set
         {
         	IColumnLink.DBDataSource = value;
         }
      }

      [Editor(typeof(Borland.Data.Web.ColumnNamePropEditor), typeof(UITypeEditor)),
		LocalizableCategoryAttribute(DBTypes.sDBWebControl),
		DefaultValue(null)]
	  [LocalizableDescriptionAttribute("ColumnName")]
      public string ColumnName
      {
      	get
         {
         	return IColumnLink.ColumnName;
         }
         set
         {
         	IColumnLink.ColumnName = value;
         }
      }
      [Editor(typeof(Borland.Data.Web.TableNamePropEditor), typeof(UITypeEditor)),
		LocalizableCategoryAttribute(DBTypes.sDBWebControl),
		DefaultValue(null)]
	  [LocalizableDescriptionAttribute("LookupTableName")]
      public string LookupTableName
      {
      	get
         {
         	return IColumnLink.LookupTableName;
         }
         set
         {
         	IColumnLink.LookupTableName = value;
         }
      }
      [Editor(typeof(Borland.Data.Web.LookupColumnNamePropEditor), typeof(UITypeEditor)),
		LocalizableCategoryAttribute(DBTypes.sDBWebControl),
      DefaultValue(null)]
	  [LocalizableDescriptionAttribute("DataTextField")]
      public override string DataTextField
      {
      	get
         {
         	return IColumnLink.DataTextField;
         }
         set
         {
         	base.DataTextField = value;
         	IColumnLink.DataTextField = value;
         }
      }
      [Editor(typeof(Borland.Data.Web.LookupColumnNamePropEditor), typeof(UITypeEditor)),
		LocalizableCategoryAttribute(DBTypes.sDBWebControl),
      DefaultValue(null)]
	  [LocalizableDescriptionAttribute("DataValueField")]
      public override string DataValueField
      {
      	get
         {
         	return IColumnLink.DataValueField;
         }
         set
         {
         	base.DataValueField = value;
         	IColumnLink.DataValueField = value;
         }
      }
      #endregion



		protected override void OnPreRender(EventArgs args)
		{
			base.OnPreRender(args);
			string s = Page.Request.QueryString[DBWebConst.sBorlandImageID];
			if( s != null )
				return;
			DataBind();
			if( TableName != LookupTableName )
				Page.RegisterHiddenField(DBWebDataSource.IdentPrefix + this.ID, IColumnLink.TableName + DBWebConst.Splitter + IColumnLink.ColumnName);
		}

      protected void SetBaseProperties()
      {
         ClassUtils.SetAppearanceProperties(FRadioButtonList, this);
         ClassUtils.SetBehaviorProperties(FRadioButtonList, this);
         ClassUtils.SetControlProps(FRadioButtonList, this);
      }

		protected override void Render(HtmlTextWriter output)
		{
			if( ClassUtils.IsDesignTime(Page) && !FColumnLink.IsDataBound )
         {

            SetBaseProperties();
         	FRadioButtonList.DataBind();
         	FRadioButtonList.RenderControl(output);
	         base.Render(output);
         }
         else
			{
	      	bool error = ClassUtils.OutputErrors(Page, output, IColumnLink);
   	      if( !error || (IColumnLink.DBDataSource as DBWebDataSource).ErrorOption != ErrorHtmlOption.logOnErrorPage )
      	   	base.Render(output);
         	else  // if going to a separate error hmtl page, output "OK" button.
	         {
   	      	ClassUtils.OutputOKButton(output);
         	   Page.Response.End();
            }
         }
		}

		public override void DataBind()
		{
      	try
         {
				base.DataSource = null;
				base.DataBind();
				base.Items.Clear();
				if( FColumnLink.IsDataBound )
	         {
   	         string CurrentValue = ClassUtils.BindLookupControl(Page, FColumnLink, this);
					base.DataBind();
					if( CurrentValue == null )
					{
						this.Items.Insert(0, "");
						this.SelectedIndex = 0;
					}
	            else
   	       		this.SelectedIndex = ClassUtils.CurrentLookupIndex(this, CurrentValue);
            }
         }
         catch(Exception ex)
         {
         	if( !ClassUtils.IsDesignTime(Page) )
            {
	            Page.Response.Write(ClassUtils.GetInternalError(Page, IColumnLink, ex, this.ID));
            }
            else
            	throw new Exception(ex.Message);
         }
      }
   }
   #endregion

   #region DBWebDropDownList
 	/// <summary>
	/// Data aware DropDownList control for use with DBWebDataSource
	/// </summary>

	[Designer("Borland.Data.Web.DBWebControlDesigner"),
   ToolboxBitmap(typeof(Borland.Data.Web.DBWebDropDownList),
   "Borland.Data.Web.DBWebDropDownList.bmp"),
	ToolboxData("<{0}:DBWebDropDownList runat=server></{0}:DBWebDropDownList>")]
	public class DBWebDropDownList : DropDownList, IDBWebLookupColumnLink, IPostBackDataHandler
	{
		private DBWebLookupColumnLink FColumnLink;
		private IDBWebLookupColumnLink IColumnLink;
		private const double minimumWidth = 80;

   	public DBWebDropDownList() : base()
      {
         FColumnLink = new DBWebLookupColumnLink(this);
         IColumnLink = (FColumnLink as IDBWebLookupColumnLink);
      }

		protected override void OnInit(EventArgs e)
		{
			base.OnInit(e);
			if( Page != null )
				Page.RegisterRequiresPostBack(this);
      }

      #region IPostBackDataHandler
      // RaisePostDataChangedEvent is called prior to DataBind()
      // DataSet and related properties are NOT available here
      // Child controls are not available
		bool IPostBackDataHandler.LoadPostData(string postDataKey,
			NameValueCollection postCollection)
      {
         if( this.Visible )
	      	FColumnLink.LoadPostData(postDataKey, postCollection);
         return false;
      }

	   void IPostBackDataHandler.RaisePostDataChangedEvent()
   	{
	   }
      #endregion

      #region IDBWebDataLink
      string IDBWebDataLink.TableName
      {
      	get
         {
         	return IColumnLink.TableName;
         }
         set
         {
            if( !ClassUtils.SameValue(IColumnLink.TableName, value) )
         		IColumnLink.TableName = value;
         }
      }
      IDBDataSource IDBWebDataLink.DBDataSource
      {
      	get
         {
         	return (IColumnLink as IDBWebDataLink).DBDataSource;
         }
         set
         {
         	IColumnLink.DBDataSource = value;
         }
      }
      #endregion
      #region IDBWebColumnLink
      string IDBWebColumnLink.ColumnName
      {
      	get
         {
         	return IColumnLink.ColumnName;
         }
         set
         {
            if( !ClassUtils.SameValue(IColumnLink.ColumnName, value) )
         		IColumnLink.ColumnName = value;
         }
      }
      #endregion
      #region IDBWebLookupColumnLink
      string IDBWebLookupColumnLink.DataTextField
      {
      	get
         {
         	return IColumnLink.DataTextField;
         }
         set
         {
            if( !ClassUtils.SameValue(IColumnLink.DataTextField, value) )
         		IColumnLink.DataTextField = value;
         }
      }
      string IDBWebLookupColumnLink.LookupTableName
      {
      	get
         {
         	return IColumnLink.LookupTableName;
         }
         set
         {
            if( !ClassUtils.SameValue(IColumnLink.LookupTableName, value) )
         		IColumnLink.LookupTableName = value;
         }
      }
      string IDBWebLookupColumnLink.DataValueField
      {
      	get
         {
         	return IColumnLink.DataValueField;
         }
         set
         {
            if( !ClassUtils.SameValue(IColumnLink.DataValueField, value) )
         		IColumnLink.DataValueField = value;
         }
      }
      #endregion
      #region DBWebLookupColumnLink
      [Editor(typeof(Borland.Data.Web.TableNamePropEditor), typeof(UITypeEditor)),
		LocalizableCategoryAttribute(DBTypes.sDBWebControl),
		DefaultValue(null)]
	  [LocalizableDescriptionAttribute("TableName")]
      public string TableName
      {
      	get
         {
	      	return IColumnLink.TableName;
         }
      	set
         {
	      	IColumnLink.TableName = value;
         }
      }
		[LocalizableCategoryAttribute(DBTypes.sDBWebControl),
		DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden),
		DefaultValue(null)]
	  [LocalizableDescriptionAttribute("DataSource")]
      public IDBDataSource DBDataSource
      {
      	get
         {
         	return IColumnLink.DBDataSource;
         }
         set
         {
         	IColumnLink.DBDataSource = value;
         }
      }

      [Editor(typeof(Borland.Data.Web.ColumnNamePropEditor), typeof(UITypeEditor)),
		LocalizableCategoryAttribute(DBTypes.sDBWebControl),
		DefaultValue(null)]
	  [LocalizableDescriptionAttribute("ColumnName")]
      public string ColumnName
      {
      	get
         {
         	return IColumnLink.ColumnName;
         }
         set
         {
         	IColumnLink.ColumnName = value;
         }
      }
      [Editor(typeof(Borland.Data.Web.TableNamePropEditor), typeof(UITypeEditor)),
		LocalizableCategoryAttribute(DBTypes.sDBWebControl),
		DefaultValue(null)]
	  [LocalizableDescriptionAttribute("LookupTableName")]
      public string LookupTableName
      {
      	get
         {
         	return IColumnLink.LookupTableName;
         }
         set
         {
         	IColumnLink.LookupTableName = value;
         }
      }
      [Editor(typeof(Borland.Data.Web.LookupColumnNamePropEditor), typeof(UITypeEditor)),
		LocalizableCategoryAttribute(DBTypes.sDBWebControl),
      DefaultValue(null)]
	  [LocalizableDescriptionAttribute("DataTextField")]
      public override string DataTextField
      {
      	get
         {
         	return IColumnLink.DataTextField;
         }
         set
         {
         	base.DataTextField = value;
         	IColumnLink.DataTextField = value;
         }
      }
      [Editor(typeof(Borland.Data.Web.LookupColumnNamePropEditor), typeof(UITypeEditor)),
		LocalizableCategoryAttribute(DBTypes.sDBWebControl),
      DefaultValue(null)]
	  [LocalizableDescriptionAttribute("DataValueField")]
      public override string DataValueField
      {
      	get
         {
         	return IColumnLink.DataValueField;
         }
         set
         {
         	base.DataValueField = value;
         	IColumnLink.DataValueField = value;
         }
      }
      #endregion

		protected override void OnPreRender(EventArgs args)
		{
			base.OnPreRender(args);
			string s = Page.Request.QueryString[DBWebConst.sBorlandImageID];
         if( s != null )
				return;
			DataBind();
			if( TableName != LookupTableName )
				Page.RegisterHiddenField(DBWebDataSource.IdentPrefix + this.ID, IColumnLink.TableName + DBWebConst.Splitter + IColumnLink.ColumnName);
		}

		protected override void Render(HtmlTextWriter output)
		{
      	bool error = ClassUtils.OutputErrors(Page, output, IColumnLink);
         if( !error || (IColumnLink.DBDataSource as DBWebDataSource).ErrorOption != ErrorHtmlOption.logOnErrorPage )
         {
         	base.Render(output);
         }
         else  // if going to a separate error hmtl page, output "OK" button.
         {
         	ClassUtils.OutputOKButton(output);
            Page.Response.End();
         }
		}

		public override void DataBind()
		{
			try
			{
				base.DataSource = null;
				if( ClassUtils.IsDesignTime(Page) && !FColumnLink.IsDataBound )
				{
					if( base.Width.Value < minimumWidth )
						base.Width = new Unit(minimumWidth);
				}
				base.DataBind();
				base.Items.Clear();
				if( FColumnLink.IsDataBound )
      	   {
					string CurrentValue = ClassUtils.BindLookupControl(Page, FColumnLink, this);
					base.DataBind();
					if( CurrentValue == null )
					{
						this.Items.Insert(0, "");
						this.SelectedIndex = 0;
					}
					else
         	 		this.SelectedIndex = ClassUtils.CurrentLookupIndex(this, CurrentValue);
            }
         }
         catch(Exception ex)
         {
         	if( !ClassUtils.IsDesignTime(Page) )
            {
	            Page.Response.Write(ClassUtils.GetInternalError(Page, IColumnLink, ex, this.ID));
            }
            else
            	throw new Exception(ex.Message);
         }
      }
   }
   #endregion
}
#endregion
